/*
 * Decompiled with CFR 0.152.
 */
package me.theminddroid.drugs.listeners;

import java.util.Objects;
import me.theminddroid.drugs.DrugUtilities;
import me.theminddroid.drugs.DrugsPlugin;
import me.theminddroid.drugs.models.Drug;
import me.theminddroid.drugs.models.DrugItems;
import me.theminddroid.drugs.models.DrugType;
import me.theminddroid.drugs.states.DrugUsageState;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitTask;

public class PsychoactiveDrugListener
implements Listener {
    FileConfiguration messageConfig = ((DrugsPlugin)DrugsPlugin.getPlugin(DrugsPlugin.class)).getConfig();

    @EventHandler
    public void onDrugConsume(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        ItemStack itemInMainHand = player.getInventory().getItemInMainHand();
        Drug drug = this.tryGetPsychoActiveDrug(itemInMainHand);
        if (drug == null) {
            return;
        }
        player.sendMessage(Objects.requireNonNull(this.messageConfig.getString("verifyUsage")));
        event.setCancelled(true);
    }

    @EventHandler
    public void onDrugUse(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack itemInMainHand = player.getInventory().getItemInMainHand();
        if (!player.isSneaking()) {
            return;
        }
        Drug drug = this.tryGetPsychoActiveDrug(itemInMainHand);
        if (drug == null) {
            return;
        }
        if (player.hasPermission("drugs.disable") && !player.isOp()) {
            player.sendMessage(Objects.requireNonNull(this.messageConfig.getString("drugPermission")));
            return;
        }
        if (!this.messageConfig.getBoolean(drug.getDrugName() + "Use.enabled")) {
            if (this.messageConfig.getBoolean("drugMessage.enabled")) {
                player.sendMessage(Objects.requireNonNull(this.messageConfig.getString("drugDisabled")));
            }
            return;
        }
        if (player.getGameMode() == GameMode.SURVIVAL && !player.isDead()) {
            int itemAmount = itemInMainHand.getAmount();
            itemInMainHand.setAmount(itemAmount - 1);
        }
        DrugType.PsychoActive drugType = (DrugType.PsychoActive)drug.getDrugType();
        player.playSound(player.getLocation(), drugType.getConsumeSound(), 10.0f, (float)(1.7 + 0.2 * Math.random()));
        player.addPotionEffect(new PotionEffect(drugType.getEffect().getEffectType(), 2400, 2));
        player.sendMessage(Objects.requireNonNull(this.messageConfig.getString("consumeStart")) + drug.name() + Objects.requireNonNull(this.messageConfig.getString("consumeMiddle")) + drugType.getEffect().getMessage() + Objects.requireNonNull(this.messageConfig.getString("consumeEnd")));
        DrugUsageState drugUsageState = DrugUtilities.getDrugUsage((Metadatable)player, drug);
        int amountOfTimesUsed = 1;
        if (drugUsageState != null) {
            amountOfTimesUsed += drugUsageState.getAmountOfTimesUsed();
            drugUsageState.getWithdrawalTask().cancel();
            player.removeMetadata(DrugUtilities.getPreviousDrugUsageKey(drug), (Plugin)DrugsPlugin.getInstance());
        }
        if (amountOfTimesUsed == 4) {
            player.sendMessage(Objects.requireNonNull(this.messageConfig.getString("passingMessage")));
            player.playSound(player.getLocation(), Sound.BLOCK_LAVA_POP, 10.0f, 0.5f);
        }
        if (amountOfTimesUsed >= 5) {
            Bukkit.getScheduler().runTaskLater((Plugin)DrugsPlugin.getInstance(), () -> player.setHealth(0.0), 1L);
            player.sendMessage(Objects.requireNonNull(this.messageConfig.getString("overdoseMessage")));
            return;
        }
        BukkitTask bukkitTask = Bukkit.getScheduler().runTaskLater((Plugin)DrugsPlugin.getInstance(), () -> {
            if (player.isOnline()) {
                player.playSound(player.getLocation(), Sound.ENTITY_GENERIC_HURT, 10.0f, 1.7f);
                player.addPotionEffect(new PotionEffect(drugType.getWithdrawalEffect().getEffectType(), 600, 2));
                player.addPotionEffect(new PotionEffect(PotionEffectType.CONFUSION, 200, 3));
                player.sendMessage(Objects.requireNonNull(this.messageConfig.getString("dizzyMessage")));
                player.sendMessage(Objects.requireNonNull(this.messageConfig.getString("withdrawalMessageStart")) + drugType.getWithdrawalEffect().getMessage() + Objects.requireNonNull(this.messageConfig.getString("withdrawalMessageEnd")));
                player.removeMetadata(DrugUtilities.getPreviousDrugUsageKey(drug), (Plugin)DrugsPlugin.getInstance());
                DrugUtilities.setPlayerWithdrawal(player, drug);
            }
        }, 2401L);
        player.setMetadata(DrugUtilities.getPreviousDrugUsageKey(drug), (MetadataValue)new FixedMetadataValue((Plugin)DrugsPlugin.getInstance(), (Object)new DrugUsageState(amountOfTimesUsed, bukkitTask)));
    }

    private Drug tryGetPsychoActiveDrug(ItemStack itemStack) {
        Drug drug = DrugItems.tryGetDrug(itemStack);
        if (drug == null) {
            return null;
        }
        if (!(drug.getDrugType() instanceof DrugType.PsychoActive)) {
            return null;
        }
        return drug;
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        for (Drug drug : Drug.values()) {
            DrugUsageState drugUsageState = DrugUtilities.getDrugUsage((Metadatable)event.getEntity(), drug);
            if (drugUsageState == null) continue;
            drugUsageState.getWithdrawalTask().cancel();
        }
    }
}

